@pushd "%~dp0" & python -x "%~f0" & timeout 10 & exit /b

# -*- coding: utf-8 -*-

import importlib
import os
import os.path
import subprocess
import sys

folder_of_this_script = os.path.abspath(__file__)


cfg_py_file = f'{os.path.splitext(os.path.basename(__file__))[0]}_cfg'
config = importlib.import_module(cfg_py_file)



cmd = [
        fr'{config.squish_dir}\bin\squishrunner',
        '--config',
        'setGlobalScriptDirs',
        ','.join(config.global_script_folders)
    ]

print("Configuring global script folders:")
print()
for s in config.global_script_folders:
    print(f'  {s}')
print()
subprocess.run(cmd)
print()
print()



cmd = [
        fr'{config.squish_dir}\squishide',
    ]
cmd.extend(config.test_suites)
print("Starting Squish IDE with test suites:")
print()
for s in config.test_suites:
    print(f'  {s}')
print()
subprocess.run(cmd)
print()
print()
